### 概述

**Fins协议**
FINS协议，全称为Factory Interface Network Service，是由日本欧姆龙（Omron）公司开发的一套用于工业自动化控制网络的通信协议。它主要用于在PLC（可编程逻辑控制器）和计算机之间进行通信，以实现数据交换和程序下载等功能。

---
### 示例

**准备**

* 中科时代出厂的工智机；

* MetaFacture V1.0.4.4编程软件；
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b5823997.png)

1.打开软件，新建工程
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b6189ebe.png)

2.选择标准工程，并命名Fins
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b69f2abc.png)

3.选择中科时代Sinsegye设备，选择PLC编程语言(本例为ST语言)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b722fbce.png)

4.登录工智机
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b7928452.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b80e0f4e.png)

5.鼠标右键“Application”—选择“属性”
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b891bf65.png)

6.点击“目标内存设置”—勾选“覆盖目标内存设置”—点击“是”
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b90094df.png)

7.中科时代支持设置最大64M的输入、输出和内存。
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b968908a.png)

8.打开程序PLC\_PRG,新建变量映射至%I、%Q、%M
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819b9d78ef2.png)

Fins协议的寄存器地址与PLC的对应如下

| 寄存器             | PLC地址 |
| ------------------ | ------- |
| CIO0\~CIO32767     | %I区    |
| CIO32768\~CIO65535 | %Q区    |
| D0\~D33554431      | %M区    |


使用中科时代Fins协议时，对%I区和%Q区传输的数据大小进行了限制：

| 变量           | 地址范围                        | 最大支持的元件数量 | 说明            |
| -------------- | ------------------------------- | ------------------ | --------------- |
| %IW0\~%IW32767 | 0x0000 \~ 0x7FFF (0\~32767)     | 32768              | I区的16位寄存器 |
| %QW0\~%QW32767 | 0x7FFF \~ 0xFFFF (32768\~65535) | 32768              | Q区的16位寄存器 |

对%M的大小没有限制，最大为64M


所以，示例PLC中：

wIn1对应的地址为I区W5（CIO5），

aInput数组对应地址为I区100\~199（CIO100\~CIO199）

wOut1对应的地址为Q区W3（CIO32771）

aOutput数组对应地址为Q区100\~199（CIO32868\~CIO32967）

wMem1对应的地址为M区W7（D7）

aMem数组对应地址为M区100\~199（D100\~D199）

***


9.登录工智机，下载并运行程序
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819bb3110f6.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819bcae12d3.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819bd38321f.png)

10.对变量任意赋值,本例赋值如下：

| 变量                       | 初始值                  |
| -------------------------- | ----------------------- |
| wIn1                       | 99                      |
| aInput\[0]-- aInput\[4]    | 11，12，13，14，15      |
| aOutput\[0]-- aOutput \[4] | 101，102，103，104，105 |
| aMem\[0]-- aMem \[4]       | 201，202，203，204，205 |
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819be7e4b76.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819bf9e0242.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c035bf92.png)

11.打开HslCommunication测试工具，选择Omron—Fins Tcp—输入IP地址（本例为192.168.105.5），默认端口号为9600，点击“连接”
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c0cbe3a2.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c15e96af.png)

***


---
### **Fins读取功能**

1. 调整数据传送的大小端，调整完成后需重新连接才能生效。
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c41c8021.png)

2. 读取我wIn1，地址为CIO5,成功读取值为99
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c4b125d4.png)


3. 读取wOut1，地址为CIO32771，成功读取
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c5392bd7.png)

4. 读取wMem1，地址为D7，成功读取。
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c5d4b729.png)

5.读取PLC的aMem数组，对应Fins的D100数据，选择“ushort读取”：
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c707d25b.png)

6.批量读取D100\~D109,数量修改为10，点击“ushort读取”
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c80a1312.png)
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c88eedeb.png)

7.读取PLC中aInput\[0]数据，起始地址为CIO100
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c92399bb.png)

8.批量读取aInput数据
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819c9b8a7cf.png)

9\. 读取PLC中aOutput\[0]数据，%Q区的起始地址为CIO32767，在PLC中aOutput\[0]映射地址为%QW100,所以aOutput\[0]对应CIO32868
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819ca68c230.png)

8.批量读取PLC中aOutput数据
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819cb2641d2.png)

---
### **Fins写入功能**

1. 写入wIn1数据，写入地址为CIO5,修改值为88
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819cbb40ccb.png)

2. 内存%M区写入，aMem\[50]对应D150,写入数据50，点击“ushort写入”。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819cc76c474.png)

3. 输入%I区写入, aInput\[51]对应CIO151,写入数据51，点击“ushort写入”。
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819ccf816b6.png)

4. 输入%Q区写入, aOutput\[52]对应CIO32920,写入数据52，点击“ushort写入”。
![](https://resource.helplook.net/docker_production/3648ne/article/wQ4MoS9t/68819d4ebb433.png)